#include <iostream>
#include "object.h"
#include "objectpair.h"
#include "simjoin.h"
using namespace std;

void getStatistic(int k, double time, string set1_name, string set2_name)
{
    Preprocess sets(set1_name, set2_name);
    sets.transformObjects();

    Simjoin exactsim(sets.set1_dest, sets.set2_dest, k);
    exactsim.join();

    Simjoin appsim(sets.set1_dest, sets.set2_dest, k);
    appsim.join(time);

    int k1 = 0;     //k' - number of right pairs in approximate results
    for (int i = 0; i <= exactsim.result_set.size() - 1; i++)
    {
        for (int j = 0; j <= exactsim.result_set.size() - 1; j++)
        if (exactsim.result_set[i] == appsim.result_set[j])
            k1++;
    }

    double a = log(1 - (double) k1/k)/((double) appsim.c_all/exactsim.c_all);
    Statistic::instance().a_stat.push_back(a);
}

int main()
{
}

